import BCF
import Pd


class ComposantScene:
    position = (50,50)
    rotation = 0
    color = [1,1,1,1]
    coment = 'commentaire par default\n'
class Projecteur(ComposantScene):
    proj_type = 0
    _valeur = 0
    num_DMX = 0
    num_proj = 0
    def __init__(self,numero):
        self.num_proj = numero
    def set_value(self,valeur):
        if self._valeur != min(max(valeur, 0), 100):
            self._valeur=min(max(valeur, 0),  100)  
            Pd.mypdconnection.send_proj(self.num_proj,self._valeur)
            for i in range(16):
                if self == BCF.myfader.fader[i].pointeur_vers_obj:
                    BCF.myfader.fader[i].change_value(self._valeur)
    def set_value_midi(self,valeur):
        if self._valeur != min(max(valeur, 0), 100):
            self._valeur=min(max(valeur, 0),  100)  
            Pd.mypdconnection.send_proj(self.num_proj,self._valeur)
            for i in range(16):
                if self == BCF.myfader.fader[i].pointeur_vers_obj:
                    BCF.myfader.fader[i].change_value_midi(self._valeur)
    def get_value(self):
        return self._valeur
    def change_proj_type(self):
        self.proj_type = (self.proj_type+1)%6
        ## TODO coder proprement le modulo (si nb de proj variable)
    ## TODO : num_DMX doit etre une liste comportant des ensemble : Num DMX + paramettres de courbe
class Groupe(ComposantScene):
    _valeur = 0
    groupe_type = 0 # pour l'affichage
    list_proj = dict()
    Id = 0
    def add_proj(self, object):
        for proj in self.get_proj_list():
            if self.get_proj(proj) == object:
                return 1 # le proj est deja ds le groupe, alors on ne fait rien
        self.list_proj[self.Id] = object
        self.Id += 1
    def del_proj(self, object):
        for proj in self.get_proj_list():
            if self.get_proj(proj) == object:
                del self.list_proj[proj]
                return 1
    def del_proj_id(self, Id):
        del self.list_proj[Id]
        print 'del succed'
        return 1
    def get_proj_list(self):
        return iter(self.list_proj)
    def get_proj(self,Id):
        return self.list_proj[Id]
    def change_groupe_type(self):
        self.groupe_type = (self.groupe_type+1)%6
        ## TODO coder proprement le modulo (si nb de groupe variable)
    def set_relative_value(self, valeur):
        for projecteur in self.get_proj_list():
            proj = self.get_proj(projecteur)
            proj.set_value(proj.get_value()+valeur)  
class Effect(ComposantScene):
    _valeur = 0     # valeur actuel
    effect_type = 0 # pour l'affichage
    effect_num = 0 # pour envoyer a pd
    def __init__(self,numero):
        self.effect_num = numero
    def set_value(self,valeur):
        if self._valeur != min(max(valeur, 0),  100):
            self._valeur = min(max(valeur, 0),  100)
            Pd.mypdconnection.send_effect(self.effect_num,self._valeur)
            for i in range(16):
                if self == BCF.myfader.fader[i].pointeur_vers_obj:
                    BCF.myfader.fader[i].change_value(self._valeur)
    def set_value_midi(self,valeur):
        if self._valeur != min(max(valeur, 0),  100):
            self._valeur = min(max(valeur, 0),  100)
            Pd.mypdconnection.send_effect(self.effect_num,self._valeur)
            for i in range(16):
                if self == BCF.myfader.fader[i].pointeur_vers_obj:
                    BCF.myfader.fader[i].change_value_midi(self._valeur)
                    
    def get_value(self):
        return self._valeur
    def change_effect_type(self):
        self.effect_type = (self.effect_type+1)%6
        ## TODO coder proprement le modulo (si nb d'effet variable)

class Rectangle(ComposantScene):
    taille = (100,10) # taille x, taille y
    rectangle_type = 0
    def change_rectangle_type(self):
        self.rectangle_type = (self.rectangle_type+1)%4
    ## TODO coder proprement le modulo (si nb de rectangle variable)

class Taille():
    taille = 1000

class Scene:
    scene = dict()
    scene[0] = Taille
    Id = 1
    
    projecteur_list = []
    groupe_list = []
    effect_list = []
    rectangle_list = []
    # list en cache pour aller plus vite lors du rendu
    # c'est les seules fct utiliser lors du TR, qd il n'y a pas d'interaction avec l'utilisateur
    def set_taille(self,taille):
        self.scene[0].taille = taille

    def get_taille(self):
        return self.scene[0].taille

    def add_object(self,objet):
        self.Id += 1   
        self.scene[self.Id] = objet
        self.calcul_all_list() # pas tres clean, mais on s'en fout du TR lorsqu'on modifie la scenne
    def del_object(self,Id):
        del self.scene[Id]
        self.calcul_all_list()
    def del_graphical_object(self,num):
        i = 0
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Projecteur) or isinstance (self.scene[Id], Effect) or isinstance (self.scene[Id], Groupe) or isinstance (self.scene[Id], Rectangle) :
                if num == i:
                    del self.scene[Id]
                    break
                i += 1
        self.calcul_all_list()
    def get_interact_object_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Projecteur) or isinstance (self.scene[Id], Effect) or isinstance (self.scene[Id], Groupe) :
                list += [Id]
        return list
        
    def get_interact_object_list_size(self):
        list = 0
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Projecteur) or isinstance (self.scene[Id], Effect) or isinstance (self.scene[Id], Groupe) :
                list += 1
        return list
    

    def get_graphical_object_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Projecteur) or isinstance (self.scene[Id], Effect) or isinstance (self.scene[Id], Groupe) or isinstance (self.scene[Id], Rectangle) :
                list += [Id]
        return list
    def get_object(self,Id):
        return self.scene[Id]

    def get_object_list(self):
        return iter(self.scene) 

    def calcul_projecteur_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Projecteur):
                list += [Id]
        return list

    def calcul_groupe_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Groupe):
                list += [Id]            
        return list
  
    def calcul_effect_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Effect):
                list += [Id]            
        return list

    def calcul_rectangle_list(self):
        list = []
        for Id in iter(self.scene):
            if  isinstance (self.scene[Id], Rectangle):
                list += [Id]            
        return list
    def calcul_all_list(self):
        self.projecteur_list = self.calcul_projecteur_list()
        self.groupe_list = self.calcul_groupe_list()
        self.effect_list = self.calcul_effect_list()
        self.rectangle_list = self.calcul_rectangle_list()
    def get_projecteur_list(self):
        return self.projecteur_list
    def get_groupe_list(self):
        return self.groupe_list
    def get_effect_list(self):
        return self.effect_list
    def get_rectangle_list(self):
        return self.rectangle_list

