#include "m_pd.h"
#include "math.h"
#include "def.h"

static t_class *jotac_class;

typedef struct _jotac {
    t_object  x_obj;
    t_outlet *to_out; // outlet
    t_outlet *to_textefile; // outlet

    t_float projecteur[nb_max_circuit][11]; // list des projecteurs
    t_float effet[nb_max_circuit][11]; // list des projecteurs
    t_float data[nb_max_circuit][11]; // list des projecteurs
    t_float forme[nb_max_circuit][11]; // list des projecteurs
    t_float groupe[nb_max_circuit][30]; // list des projecteurs
    t_float texte[nb_max_circuit][200]; // list des projecteurs
    
    t_float valeur_circuit[nb_max_circuit][6]; // valeur actuel, valeur initial, valeur final, temps de rampe, curve , temps actuel 
    t_float valeur_effet[nb_max_circuit][6];
    t_float valeur_data[nb_max_circuit][7]; // 7eme valeur = derniere valeur envoyé
    t_float memoire[nb_max_memoires][3 * nb_max_circuit]; // memoires
    t_atom nom_memoire[nb_max_memoires]; // nom des memoires

    t_float valeur_bus_lumiere[nb_max_circuit]; // valeur interne + valeur externe (provenant des effet par exemple)
    t_float patch[nb_max_patch][4]; // numero circuit, numero dmx, amplitude, courbe
    t_float valeur_DMX[nb_max_DMX][2]; // sorie DMX (apres le patch) (avec une memoire pour eviter d'envoyer les doublons)

    t_int force_DMX[2]; // TODO : a initialiser et reset propre
} t_jotac;

float interpol(float debut, float fin, float proportion, float curve)
{
    float k;
    float c = (curve/4)+0.5;
    if (c < 0.5)
        c = 2*c;
    else
        c = tan(1.5708 * c);
    k = pow(1-proportion, c);
    k = pow(1-k, 1/c);
    return(debut*(1-k) + fin * k);
}

void jotac_bang(t_jotac *x)
{
    t_atom element[nb_max_circuit+2];
    int i;
    t_atom list_out[nb_max_circuit+1];
    
    for (i=0; i<nb_max_patch; i++)
        if (x->patch[i][0] >=0) // calcul les valeur DMX en fct du patch
        {
            x->valeur_DMX[(int)x->patch[i][1]][0] = interpol(0,255*x->patch[i][2],x->valeur_bus_lumiere[(int)x->patch[i][0]],x->patch[i][3]);
            // TODO limiter les valeurs min et max
        }
    
    //if(x->force_DMX>0)
      //  x->valeur_DMX[x->force_DMX-1][0]=255; // force valeur DMX
        
    // dump DMX
    for (i=0; i<nb_max_circuit; i++)
        if (i!=x->force_DMX[0]-1)
        {
            if (x->valeur_DMX[i][0] != x->valeur_DMX[i][1])
            {
                SETFLOAT(&element[0],i+1);
                SETFLOAT(&element[1],x->valeur_DMX[i][0]);
                outlet_anything(x->to_out,gensym("DMX"),2,element);
                x->valeur_DMX[i][1] = x->valeur_DMX[i][0];
            }
        }
        else
        {
            switch (x->force_DMX[1])
            {
                case 0: // on envoie 0
                    x->force_DMX[1]=-1;
                    SETFLOAT(&element[0],i+1);
                SETFLOAT(&element[1],x->valeur_DMX[i][0]);
                    outlet_anything(x->to_out,gensym("DMX"),2,element);
                    break;
                case 1:
                    x->force_DMX[1]=2;
                    SETFLOAT(&element[0],i+1);
                    SETFLOAT(&element[1],255);
                    outlet_anything(x->to_out,gensym("DMX"),2,element);
                    break;
            }
            
        }
    
    

    // dump data
    for (i=0; i<nb_max_circuit; i++)
        if (x->valeur_data[i][0] != x->valeur_data[i][6])
        {
            SETFLOAT(&element[0],i+1);
            SETFLOAT(&element[1],x->valeur_data[i][0]);
            outlet_anything(x->to_out,gensym("data"),2,element);
            x->valeur_data[i][6] = x->valeur_data[i][0];
        }
    
    SETFLOAT(&element[0],0); // broadcast    
    SETSYMBOL(&element[1], gensym("list_circuits"));
    for(i=0; i<nb_max_circuit; i++)
    {
        SETFLOAT(&element[i+2], x->valeur_bus_lumiere[i] );
    }
    outlet_anything(x->to_out,&s_list, nb_max_circuit+2,element);
    
    SETFLOAT(&element[0],0); // broadcast    
    SETSYMBOL(&element[1], gensym("list_dmx"));
    for(i=0; i<nb_max_circuit; i++)
    {
        SETFLOAT(&element[i+2], x->valeur_DMX[i][0] );
    }
    if ((x->force_DMX[0] > 0)&(x->force_DMX[1] > 0))
        SETFLOAT(&element[x->force_DMX[0]+1], 255 );

    outlet_anything(x->to_out,&s_list, nb_max_circuit+2,element);
}

void jotac_reset(t_jotac *x)
{
    int i;
    t_atom element[2];
    
    for(i=0;i<nb_max_circuit;i++)
    {
        // x->projecteur[i][0] = 0;
        // x->effet[i][0] = 0;
        // x->data[i][0] = 0;
        // x->forme[i][0] = 0;
        // x->groupe[i][0] = 0;
        // x->texte[i][0] = 0;
        
        x->valeur_circuit[i][0] = 0;
        x->valeur_circuit[i][3] = -1;
        x->valeur_effet[i][0] = 0;
        x->valeur_effet[i][3] = -1;
        x->valeur_data[i][0] = 0;
        x->valeur_data[i][3] = -1; // pas de line
        x->valeur_data[i][6] = -1; // forcer l'envoie des data au demarage
        x->valeur_bus_lumiere[i] = 0;        
    }
    
    for(i=0;i<nb_max_DMX;i++)
    {
        x->valeur_DMX[i][1] = -1; // pour forcer l'envoie au demarage
        x->valeur_DMX[i][0] = 0;                
    }
    
    for(i=0;i<nb_max_circuit;i++)
    { // del projecteur
        if (x->projecteur[i][0] != 0)
        {
            x->projecteur[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_projecteur"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_circuit;i++)
    { // del effet
        if (x->effet[i][0] != 0)
        {
            x->effet[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_effet"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_circuit;i++)
    { // del projecteur
        if (x->data[i][0] != 0)
        {
            x->data[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_data"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_circuit;i++)
    { // del forme
        if (x->forme[i][0] != 0)
        {
            x->forme[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_forme"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_circuit;i++)
    { // del groupe
        if (x->groupe[i][0] != 0)
        {
            x->groupe[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_groupe"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_circuit;i++)
    { // del texte
        if (x->texte[i][0] != 0)
        {
            x->texte[i][0] = 0;
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("change_texte"));
            SETFLOAT(&element[2],i); 
            SETFLOAT(&element[3],0); 
            SETFLOAT(&element[4],0); 
            outlet_anything(x->to_out,&s_list,5,element);
        }
    }
    for(i=0;i<nb_max_memoires;i++)        
        SETSYMBOL(&x->nom_memoire[i], gensym("vide")); // nom des memoires
    for (i=0; i<nb_max_patch; i++)
        {
            x->patch[i][0]=-1;
            x->patch[i][1]=-1; // clear la cannal DMX associé a tout les projecteurs
            x->patch[i][2]=1; // amplitude
            x->patch[i][3]=0; // courbe
        }
}

void jotac_time(t_jotac *x, t_float inc_time)
{
    t_float tmp;
    int i;
    t_atom element[nb_max_circuit+2];

    // calcul les rampes
    for (i=0; i< nb_max_circuit; i++)
    {
        if ((x->valeur_circuit[i][4] < x->valeur_circuit[i][3]) & (x->valeur_circuit[i][1] != x->valeur_circuit[i][2]) )
            // si la rampe n'est pas fini et que la valeur final soit diferente de la valeur initial
        {
            x->valeur_circuit[i][5] += inc_time; // incerment le temps actuel de la ramp par le temps ecoulé
            if (x->valeur_circuit[i][5] > x->valeur_circuit[i][3]) // en fait, on a fini la rampe
            {
                x->valeur_circuit[i][0] = x->valeur_circuit[i][2]; // valeur final
                x->valeur_circuit[i][3] = -1; // plus de rampe
            }
            else
                x->valeur_circuit[i][0] = interpol(x->valeur_circuit[i][1], x->valeur_circuit[i][2], x->valeur_circuit[i][5]/x->valeur_circuit[i][3], x->valeur_circuit[i][4]); // calcul la valeur actuel

            SETFLOAT(&element[0],0); // on envoie le resultat en broadcast    
            SETSYMBOL(&element[1], gensym("valeur_circuit"));
            SETFLOAT(&element[2],i+1); 
            SETFLOAT(&element[3],x->valeur_circuit[i][0]); 
            outlet_anything(x->to_out,&s_list,4,element);    
        }
        
        if ((x->valeur_effet[i][4] < x->valeur_effet[i][3]) & (x->valeur_effet[i][1] != x->valeur_effet[i][2]) )
            // si la rampe n'est pas fini et que la valeur final soit diferente de la valeur initial
        {
            x->valeur_effet[i][5] += inc_time; // incerment le temps actuel de la ramp par le temps ecoulé
            if (x->valeur_effet[i][5] > x->valeur_effet[i][3]) // en fait, on a fini la rampe
            {
                x->valeur_effet[i][0] = x->valeur_effet[i][2]; // valeur final
                x->valeur_effet[i][3] = -1; // plus de rampe
            }
            else
                x->valeur_effet[i][0] = interpol(x->valeur_effet[i][1], x->valeur_effet[i][2], x->valeur_effet[i][5]/x->valeur_effet[i][3], x->valeur_effet[i][4]); // calcul la valeur actuel

            SETFLOAT(&element[0],0); // on envoie le resultat en broadcast    
            SETSYMBOL(&element[1], gensym("valeur_effet"));
            SETFLOAT(&element[2],i+1); 
            SETFLOAT(&element[3],x->valeur_effet[i][0]); 
            outlet_anything(x->to_out,&s_list,4,element);    
        }
        if ((x->valeur_data[i][4] < x->valeur_data[i][3]) & (x->valeur_data[i][1] != x->valeur_data[i][2]) )
            // si la rampe n'est pas fini et que la valeur final soit diferente de la valeur initial
        {
            x->valeur_data[i][5] += inc_time; // incerment le temps actuel de la ramp par le temps ecoulé
            if (x->valeur_data[i][5] > x->valeur_data[i][3]) // en fait, on a fini la rampe
            {
                x->valeur_data[i][0] = x->valeur_data[i][2]; // valeur final
                x->valeur_data[i][3] = -1; // plus de rampe
            }
            else
                x->valeur_data[i][0] = interpol(x->valeur_data[i][1], x->valeur_data[i][2], x->valeur_data[i][5]/x->valeur_data[i][3], x->valeur_data[i][4]); // calcul la valeur actuel

            SETFLOAT(&element[0],0); // on envoie le resultat en broadcast    
            SETSYMBOL(&element[1], gensym("valeur_data"));
            SETFLOAT(&element[2],i+1); 
            SETFLOAT(&element[3],x->valeur_data[i][0]); 
            outlet_anything(x->to_out,&s_list,4,element);    
        }
    }
    
    // copie des valeur avant les effets
    for (i=0; i< nb_max_circuit; i++)
        x->valeur_bus_lumiere[i] = x->valeur_circuit[i][0];
}

void jotac_save(t_jotac *x)
{
    // post("dump all");
    int i, j;
    t_atom element[200];
    t_atom save_mem[nb_max_circuit + 2];

    for (i=0; i< nb_max_circuit; i++)
        if (x->projecteur[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("projecteur"));
            SETFLOAT(&element[1],i);
            for (j=0; j<11; j++)
                SETFLOAT(&element[j+2],x->projecteur[i][j]);
            outlet_anything(x->to_textefile,&s_list,13,element);
        }
    for (i=0; i< nb_max_circuit; i++)
        if (x->effet[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("effet"));
            SETFLOAT(&element[1],i);
            for (j=0; j<11; j++)
                SETFLOAT(&element[j+2],x->effet[i][j]);
            outlet_anything(x->to_textefile,&s_list,13,element);
        }
    for (i=0; i< nb_max_circuit; i++)
        if (x->data[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("data"));
            SETFLOAT(&element[1],i);
            for (j=0; j<11; j++)
                SETFLOAT(&element[j+2],x->data[i][j]);
            outlet_anything(x->to_textefile,&s_list,13,element);
        }
    for (i=0; i< nb_max_circuit; i++)
        if (x->forme[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("forme"));
            SETFLOAT(&element[1],i);
            for (j=0; j<11; j++)
                SETFLOAT(&element[j+2],x->forme[i][j]);
            outlet_anything(x->to_textefile,&s_list,13,element);
        }
    for (i=0; i< nb_max_circuit; i++)
        if (x->texte[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("texte"));
            SETFLOAT(&element[1],i);
            for (j=0; j<12+x->texte[i][11]; j++)
                SETFLOAT(&element[j+2],x->texte[i][j]);
            outlet_anything(x->to_textefile,&s_list,14+x->texte[i][11],element);
        }
    for (i=0; i< nb_max_circuit; i++)
        if (x->groupe[i][0]!=0)
        {
            SETSYMBOL(&element[0], gensym("groupe"));
            SETFLOAT(&element[1],i);
            for (j=0; j<12+x->groupe[i][11]; j++)
                SETFLOAT(&element[j+2],x->groupe[i][j]);
            outlet_anything(x->to_textefile,&s_list,14+x->groupe[i][11],element);
        }
    for (i=0; i< nb_max_memoires; i++)
        if (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide"))
        {
            SETSYMBOL(&save_mem[0], gensym("memoire_circuit"));
            SETSYMBOL(&save_mem[1], atom_getsymbol(&x->nom_memoire[i]));
            for (j=0; j<nb_max_circuit; j++)
                SETFLOAT(&save_mem[j+2],x->memoire[i][j]);
            outlet_anything(x->to_textefile,&s_list,nb_max_circuit+2,save_mem);
        }
    for (i=0; i< nb_max_memoires; i++)
        if (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide"))
        {
            SETSYMBOL(&save_mem[0], gensym("memoire_effet"));
            SETSYMBOL(&save_mem[1], atom_getsymbol(&x->nom_memoire[i]));
            for (j=0; j<nb_max_circuit; j++)
                SETFLOAT(&save_mem[j+2],x->memoire[i][j+nb_max_circuit]);
            outlet_anything(x->to_textefile,&s_list,nb_max_circuit+2,save_mem);
        }
        for (i=0; i< nb_max_memoires; i++)
        if (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide"))
        {
            SETSYMBOL(&save_mem[0], gensym("memoire_data"));
            SETSYMBOL(&save_mem[1], atom_getsymbol(&x->nom_memoire[i]));
            for (j=0; j<nb_max_circuit; j++)
                SETFLOAT(&save_mem[j+2],x->memoire[i][j+2*nb_max_circuit]);
            outlet_anything(x->to_textefile,&s_list,nb_max_circuit+2,save_mem);
        }
}

void jotac_list(t_jotac *x, t_symbol *s, int argc, t_atom *argv)
{   // post("list");  1er argument = id du controleur emeteur de l'information
    
    float tmp; 
    int num_mem;
    int i, j;
    t_atom element[200];
    t_float curent_mem_up_time = 0;
    t_float curent_mem_down_time = 0;
    t_float curent_mem_up_curve = 0;
    t_float curent_mem_down_curve = 0;
    
    if(atom_getsymbolarg(0, argc, argv) == gensym("patch") & (atom_getsymbolarg(1, argc, argv) == gensym("clear")))
    {
        for (i=0; i<nb_max_patch; i++)
        {
            x->patch[i][0]=-1;
            x->patch[i][1]=-1; // clear la cannal DMX associé a tout les projecteurs
        }
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("patch") & (atom_getsymbolarg(1, argc, argv) == gensym("del")))
    {
        // TODO
        // del circuit -> detruit toutes les occurences du circuit ds le patch  
        // del circuit et DMX -> detruit les occurence du circuit associé a un cannal dmx
        post("TODO");
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("patch") & (atom_getsymbolarg(1, argc, argv) == gensym("add")))
    {
        i=0;
        while( x->patch[i][0] >= 0) i++; // trouver un index vide
        // TODO eviter les depassement de i
        
        if (argc >= 4)
        {
            x->patch[i][0]=atom_getfloatarg(2,argc,argv)-1;
            x->patch[i][1]=atom_getfloatarg(3,argc,argv)-1;
            x->patch[i][2]=1;
            x->patch[i][3]=0;
        }
        if (argc >= 5)
            x->patch[i][2]=atom_getfloatarg(4,argc,argv);
        if (argc >= 6)
            x->patch[i][3]=atom_getfloatarg(5,argc,argv);
        // post("%d, %f %f %f %f",i,x->patch[i][0],x->patch[i][1],x->patch[i][2],x->patch[i][3]);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("patch") & (atom_getsymbolarg(1, argc, argv) == gensym("droit")))
    {
        for (i=0; (i< nb_max_patch) & (i<nb_max_circuit); i++)
        {
            x->patch[i][0] = i;
            x->patch[i][1] = i;
            x->patch[i][2] = 1;
            x->patch[i][3] = 0;
        }
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("projecteur")))
    { // load projecteur
        j=atom_getfloatarg(2,argc,argv);
        for(i=0; (i<11)&(i<argc-2); i++)
            x->projecteur[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("projecteur"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->projecteur[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("effet")))
    { // load effet
        j=atom_getfloatarg(2,argc,argv);
        for(i=0; (i<11)&(i<argc-2); i++)
            x->effet[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("effet"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->effet[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("data")))
    { // load data
        j=atom_getfloatarg(2,argc,argv);
        for(i=0; (i<11)&(i<argc-2); i++)
            x->data[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("data"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->data[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("forme")))
    { // load forme
        j=atom_getfloatarg(2,argc,argv);
        for(i=0; (i<11)&(i<argc-2); i++)
            x->forme[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("forme"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->forme[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("groupe")))
    { // load groupe
        tmp = atom_getfloatarg(14,argc,argv); // nb lettre
        j=atom_getfloatarg(2,argc,argv);
        for(i=0; i< 12+tmp; i++)
            x->groupe[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("groupe"));
        SETFLOAT(&element[2],j);
        for (i=0; i<12+tmp; i++)
            SETFLOAT(&element[i+3],x->groupe[j][i]);
        outlet_anything(x->to_out,&s_list,15+tmp,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("texte")))
    { // load texte
        j=atom_getfloatarg(2,argc,argv);
        tmp = atom_getfloatarg(14,argc,argv); // nb lettre
        for(i=0; i<12+tmp; i++)
            x->texte[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("texte"));
        SETFLOAT(&element[2],j);
        for (i=0; i<12+tmp; i++)
            SETFLOAT(&element[i+3],x->texte[j][i]);
        outlet_anything(x->to_out,&s_list,15+tmp,element);
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("memoire_circuit")))
    { // load memoire circuit
        i=0;
        while((i<nb_max_memoires) & (atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(2, argc, argv)) )
            i++; // on cherche si la memoire existe deja
        if (i==nb_max_memoires) // la memoire n'existe pas
        {
            i=0;
            while((i<nb_max_memoires-1) & (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide")) )
                i++; // on cherche une memoire vide
        }
        num_mem = i;
        SETSYMBOL(&x->nom_memoire[num_mem], atom_getsymbolarg(2, argc, argv));
        for (i=0; i< fmin(nb_max_circuit,argc+2) ; i++)
        {
            x->memoire[num_mem][i] = atom_getfloatarg(i+3,argc,argv);
        }
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("memoire_effet")))
    { // load memoire effet
        i=0;
        while((i<nb_max_memoires) & (atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(2, argc, argv)) )
            i++; // on cherche si la memoire existe deja
        if (i==nb_max_memoires) // la memoire n'existe pas
        {
            i=0;
            while((i<nb_max_memoires-1) & (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide")) )
                i++; // on cherche une memoire vide
        }
        num_mem = i;
        SETSYMBOL(&x->nom_memoire[num_mem], atom_getsymbolarg(2, argc, argv));
        for (i=0; i< fmin(nb_max_circuit,argc+2) ; i++)
        {
            x->memoire[num_mem][i+nb_max_circuit] = atom_getfloatarg(i+3,argc,argv);
        }
    }
    else
    if(atom_getsymbolarg(0, argc, argv) == gensym("load") & (atom_getsymbolarg(1, argc, argv) == gensym("memoire_data")))
    { // load memoire data
        i=0;
        while((i<nb_max_memoires) & (atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(2, argc, argv)) )
            i++; // on cherche si la memoire existe deja
        if (i==nb_max_memoires) // la memoire n'existe pas
        {
            i=0;
            while((i<nb_max_memoires-1) & (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide")) )
                i++; // on cherche une memoire vide
        }
        num_mem = i;
        SETSYMBOL(&x->nom_memoire[num_mem], atom_getsymbolarg(2, argc, argv));
        for (i=0; i< fmin(nb_max_circuit,argc+2) ; i++)
        {
            x->memoire[num_mem][i+2*nb_max_circuit] = atom_getfloatarg(i+3,argc,argv);
        }
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rampe") & (atom_getsymbolarg(2, argc, argv) == gensym("circuit")))
    { // changement de la valeur d'un circuit
        j = (int)atom_getfloatarg(3,argc,argv); // circuit du proj
        tmp = x->valeur_circuit[j-1][0];
        x->valeur_circuit[j-1][1] = tmp; // valeur actuel
        x->valeur_circuit[j-1][2] = atom_getfloatarg(4,argc,argv); // valeur final
        x->valeur_circuit[j-1][5] = 0; // debut du line

        if (argc<=5)
        { // pas de line
            x->valeur_circuit[j-1][0] = atom_getfloatarg(4,argc,argv);
            x->valeur_circuit[j-1][3] = -1; // pas de line
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("valeur_circuit"));
            SETFLOAT(&element[2],j); 
            SETFLOAT(&element[3],atom_getfloatarg(4,argc,argv)); 
            outlet_anything(x->to_out,&s_list,4,element);            
        }
        if (argc==6)
            x->valeur_circuit[j-1][3] = atom_getfloatarg(5,argc,argv); // line
        if ((argc>=7) & (x->valeur_circuit[j-1][1] < x->valeur_circuit[j-1][2])) 
            x->valeur_circuit[j-1][3] = atom_getfloatarg(5,argc,argv); // ramp up
        if ((argc>=7) & (x->valeur_circuit[j-1][1] > x->valeur_circuit[j-1][2])) 
            x->valeur_circuit[j-1][3] = atom_getfloatarg(6,argc,argv); // ramp down
        x->valeur_circuit[j-1][4] = 0; // curve
        if (argc==8) 
            x->valeur_circuit[j-1][4] = atom_getfloatarg(7,argc,argv); // curve
        if ((argc>=9) & (x->valeur_circuit[j-1][1] < x->valeur_circuit[j-1][2])) 
            x->valeur_circuit[j-1][4] = atom_getfloatarg(7,argc,argv); // curve up
        if ((argc>=9) & (x->valeur_circuit[j-1][1] > x->valeur_circuit[j-1][2])) 
            x->valeur_circuit[j-1][4] = atom_getfloatarg(8,argc,argv); // curve down
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rampe") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // changement de la valeur d'un effet
        j = (int)atom_getfloatarg(3,argc,argv); // circuit du effet
        tmp = x->valeur_effet[j-1][0];
        x->valeur_effet[j-1][1] = tmp; // valeur actuel
        x->valeur_effet[j-1][2] = atom_getfloatarg(4,argc,argv); // valeur final
        x->valeur_effet[j-1][5] = 0; // debut du line

        if (argc<=5)
        { // pas de line
            x->valeur_effet[j-1][0] = atom_getfloatarg(4,argc,argv);
            x->valeur_effet[j-1][3] = -1; // pas de line
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("valeur_effet"));
            SETFLOAT(&element[2],j); 
            SETFLOAT(&element[3],atom_getfloatarg(4,argc,argv)); 
            outlet_anything(x->to_out,&s_list,4,element);            
        }
        if (argc==6)
            x->valeur_effet[j-1][3] = atom_getfloatarg(5,argc,argv); // line
        if ((argc>=7) & (x->valeur_effet[j-1][1] < x->valeur_effet[j-1][2])) 
            x->valeur_effet[j-1][3] = atom_getfloatarg(5,argc,argv); // ramp up
        if ((argc>=7) & (x->valeur_effet[j-1][1] > x->valeur_effet[j-1][2])) 
            x->valeur_effet[j-1][3] = atom_getfloatarg(6,argc,argv); // ramp down
        x->valeur_effet[j-1][4] = 0; // curve
        if (argc==8) 
            x->valeur_effet[j-1][4] = atom_getfloatarg(7,argc,argv); // curve
        if ((argc>=9) & (x->valeur_effet[j-1][1] < x->valeur_effet[j-1][2])) 
            x->valeur_effet[j-1][4] = atom_getfloatarg(7,argc,argv); // curve up
        if ((argc>=9) & (x->valeur_effet[j-1][1] > x->valeur_effet[j-1][2])) 
            x->valeur_circuit[j-1][4] = atom_getfloatarg(8,argc,argv); // curve down
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rampe") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // changement de la valeur d'un data
        j = (int)atom_getfloatarg(3,argc,argv); // circuit du data
        tmp = x->valeur_data[j-1][0];
        x->valeur_data[j-1][1] = tmp; // valeur actuel
        x->valeur_data[j-1][2] = atom_getfloatarg(4,argc,argv); // valeur final
        x->valeur_data[j-1][5] = 0; // debut du line

        if (argc<=5)
        { // pas de line
            x->valeur_data[j-1][0] = atom_getfloatarg(4,argc,argv);
            x->valeur_data[j-1][3] = -1; // pas de line
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("valeur_data"));
            SETFLOAT(&element[2],j); 
            SETFLOAT(&element[3],atom_getfloatarg(4,argc,argv)); 
            outlet_anything(x->to_out,&s_list,5,element);            
        }
        if (argc==6)
            x->valeur_data[j-1][3] = atom_getfloatarg(5,argc,argv); // line
        if ((argc>=7) & (x->valeur_data[j-1][1] < x->valeur_data[j-1][2])) 
            x->valeur_data[j-1][3] = atom_getfloatarg(5,argc,argv); // ramp up
        if ((argc>=7) & (x->valeur_data[j-1][1] > x->valeur_data[j-1][2])) 
            x->valeur_data[j-1][3] = atom_getfloatarg(6,argc,argv); // ramp down
        x->valeur_data[j-1][4] = 0; // curve
        if (argc==8) 
            x->valeur_data[j-1][4] = atom_getfloatarg(7,argc,argv); // curve
        if ((argc>=9) & (x->valeur_data[j-1][1] < x->valeur_data[j-1][2])) 
            x->valeur_data[j-1][4] = atom_getfloatarg(7,argc,argv); // curve up
        if ((argc>=9) & (x->valeur_data[j-1][1] > x->valeur_data[j-1][2])) 
            x->valeur_data[j-1][4] = atom_getfloatarg(8,argc,argv); // curve down
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("effet") & (atom_getsymbolarg(2, argc, argv) == gensym("max")))
    { // bus d'effet
        i = (int)atom_getfloatarg(3,argc,argv); // num de l'effet
        i--;
        j = (int)atom_getfloatarg(4,argc,argv); // numero du circuit
        j--;
        // TODO : limiter i, j a des valeur possible
        x->valeur_bus_lumiere[j] = fmax(x->valeur_bus_lumiere[j], atom_getfloatarg(5,argc,argv) * x->valeur_effet[i][0] );
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("circuit") & (atom_getsymbolarg(2, argc, argv) == gensym("max")))
    { // control manuel des circuits
        i = (int)atom_getfloatarg(3,argc,argv); // num du circuit
        i--;
        // TODO : limiter i a des valeur possible
        x->valeur_bus_lumiere[i] = fmax(x->valeur_bus_lumiere[i], atom_getfloatarg(4,argc,argv) );
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("memoire") & (atom_getsymbolarg(2, argc, argv) == gensym("save")))
    { // TODO changer pour prendre en compte un symbol plutot qu'un numero
        i=0;
        while((i<nb_max_memoires) & (atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(3, argc, argv)) )
            i++; // on cherche si la memoire existe deja
        if (i==nb_max_memoires) // la memoire n'existe pas
        {
            i=0;
            while((i<nb_max_memoires-1) & (atom_getsymbol(&x->nom_memoire[i]) != gensym("vide")) )
                i++; // on cherche une memoire vide
        }
        num_mem = i;
        SETSYMBOL(&x->nom_memoire[num_mem], atom_getsymbolarg(3, argc, argv)); 
        // post("i %d", i);  
        for (i=0; i< nb_max_circuit; i++)
        {
            x->memoire[num_mem][i] = x->valeur_circuit[i][0]; // valeur du circuit actuel
            x->memoire[num_mem][i+nb_max_circuit] = x->valeur_effet[i][0]; // 
            x->memoire[num_mem][i+2*nb_max_circuit] = x->valeur_data[i][0]; //
        }
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("memoire") & (atom_getsymbolarg(2, argc, argv) == gensym("load")))
    {
        i=0;
        while((atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(3,argc,argv))&(i<nb_max_memoires)) 
            i++; // on cherche la memoire
        
        if (i<nb_max_memoires)
        {
            num_mem = i; // numero de la memoire a charger
            if (argc <= 4) // pas de line
            {
                for (i=0; i<nb_max_circuit; i++)
                {
                    x->valeur_circuit[i][3] = -1; // pas de line
                    if (x->valeur_circuit[i][0] != x->memoire[num_mem][i])
                    {
                        x->valeur_circuit[i][0] = x->memoire[num_mem][i];
                        SETFLOAT(&element[0],0); // broadcast    
                        SETSYMBOL(&element[1], gensym("valeur_circuit"));
                        SETFLOAT(&element[2],i+1); 
                        SETFLOAT(&element[3],x->valeur_circuit[i][0]); 
                        outlet_anything(x->to_out,&s_list,4,element);   
                    }
                    
                    x->valeur_effet[i][3] = -1; // pas de line
                    if (x->valeur_effet[i][0] != x->memoire[num_mem][i+nb_max_circuit])
                    {
                        x->valeur_effet[i][0] = x->memoire[num_mem][i+nb_max_circuit];
                        SETFLOAT(&element[0],0); // broadcast    
                        SETSYMBOL(&element[1], gensym("valeur_effet"));
                        SETFLOAT(&element[2],i+1); 
                        SETFLOAT(&element[3],x->valeur_effet[i][0]); 
                        outlet_anything(x->to_out,&s_list,4,element);   
                    }
                    
                    x->valeur_data[i][3] = -1; // pas de line
                    if (x->valeur_data[i][0] != x->memoire[num_mem][i+2*nb_max_circuit])
                    {
                        x->valeur_data[i][0] = x->memoire[num_mem][i+2*nb_max_circuit];
                        SETFLOAT(&element[0],0); // broadcast    
                        SETSYMBOL(&element[1], gensym("valeur_data"));
                        SETFLOAT(&element[2],i+1); 
                        SETFLOAT(&element[3],x->valeur_data[i][0]); 
                        outlet_anything(x->to_out,&s_list,4,element);   
                    }
                }
            }
            else // la rampe depend du nb d'arguments
            {
                if (argc==5)
                {
                    curent_mem_up_time = atom_getfloatarg(4,argc,argv);
                    curent_mem_up_curve = 0;
                    curent_mem_down_time = atom_getfloatarg(4,argc,argv);
                    curent_mem_down_curve = 0;
                }
                if (argc==6)
                {
                    curent_mem_up_time = atom_getfloatarg(4,argc,argv);
                    curent_mem_up_curve = 0;
                    curent_mem_down_time = atom_getfloatarg(5,argc,argv);
                    curent_mem_down_curve = 0;
                }
                if (argc==7)
                {
                    curent_mem_up_time = atom_getfloatarg(4,argc,argv);
                    curent_mem_up_curve = atom_getfloatarg(6,argc,argv);
                    curent_mem_down_time = atom_getfloatarg(5,argc,argv);
                    curent_mem_down_curve = atom_getfloatarg(6,argc,argv);
                }
                if (argc>=8)
                {
                    curent_mem_up_time = atom_getfloatarg(4,argc,argv);
                    curent_mem_up_curve = atom_getfloatarg(6,argc,argv);
                    curent_mem_down_time = atom_getfloatarg(5,argc,argv);
                    curent_mem_down_curve = atom_getfloatarg(7,argc,argv);
                }
                for (i=0; i<nb_max_circuit; i++)
                {
                    tmp = x->valeur_circuit[i][0];
                    x->valeur_circuit[i][1] = tmp; // valeur initial = actuel
                    x->valeur_circuit[i][2] = x->memoire[num_mem][i]; // valeur final
                    if(x->valeur_circuit[i][1] < x->valeur_circuit[i][2])
                    {
                        x->valeur_circuit[i][3] = curent_mem_up_time;
                        x->valeur_circuit[i][4] = curent_mem_up_curve;
                    }
                    else
                    {
                        x->valeur_circuit[i][3] = curent_mem_down_time;
                        x->valeur_circuit[i][4] = curent_mem_down_curve;
                    }
                    x->valeur_circuit[i][5] = 0; // temps actuel
                    
                    tmp = x->valeur_effet[i][0];
                    x->valeur_effet[i][1] = tmp; // valeur initial = actuel
                    x->valeur_effet[i][2] = x->memoire[num_mem][i+nb_max_circuit]; // valeur final
                    if(x->valeur_effet[i][1] < x->valeur_effet[i][2])
                    {
                        x->valeur_effet[i][3] = curent_mem_up_time;
                        x->valeur_effet[i][4] = curent_mem_up_curve;
                    }
                    else
                    {
                        x->valeur_effet[i][3] = curent_mem_down_time;
                        x->valeur_effet[i][4] = curent_mem_down_curve;
                    }
                    x->valeur_effet[i][5] = 0; // temps actuel
                    
                    tmp = x->valeur_data[i][0];
                    x->valeur_data[i][1] = tmp; // valeur initial = actuel
                    x->valeur_data[i][2] = x->memoire[num_mem][i+2*nb_max_circuit]; // valeur final
                    if(x->valeur_data[i][1] < x->valeur_data[i][2])
                    {
                        x->valeur_data[i][3] = curent_mem_up_time;
                        x->valeur_data[i][4] = curent_mem_up_curve;
                    }
                    else
                    {
                        x->valeur_data[i][3] = curent_mem_down_time;
                        x->valeur_data[i][4] = curent_mem_down_curve;
                    }
                    x->valeur_data[i][5] = 0; // temps actuel
                }
            }
        }
        else
            post("memoire pas trouvé");
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("memoire") & (atom_getsymbolarg(2, argc, argv) == gensym("delete")))
    {   
        i=0;
        while((atom_getsymbol(&x->nom_memoire[i]) != atom_getsymbolarg(3,argc,argv))&(i<nb_max_memoires)) 
            i++; // on cherche la memoire
        if (i<nb_max_memoires)
            SETSYMBOL(&x->nom_memoire[i], gensym("vide")); // nom des memoires
        else
            post("memoire pas trouvé");
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // changement de la valeur d'un projecteur  
    
        i = (int)atom_getfloatarg(3,argc,argv); // index du proj
        j = x->projecteur[i][0]; // circuit du proj
        tmp = x->valeur_circuit[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_circuit[j-1][0] = tmp;
        x->valeur_circuit[j-1][3] = -1; // pas de "line"        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_circuit"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur_nb")))
    { // changement de la valeur d'un circuit
    
        j = (int)atom_getfloatarg(3,argc,argv); // circuit du proj
        tmp = x->valeur_circuit[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_circuit[j-1][0] = tmp;
        x->valeur_circuit[j-1][3] = -1; // pas de line
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_circuit"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // changement de la valeur d'un effet
        i = (int)atom_getfloatarg(3,argc,argv); // index du effet
        j = x->effet[i][0]; // position de l'effet
        tmp = x->valeur_effet[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_effet[j-1][0] = tmp;
        x->valeur_effet[j-1][3] = -1;
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_effet"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("effet_nb")))
    { // changement de la valeur d'un effet
        j = (int)atom_getfloatarg(3,argc,argv); // index du effet
        tmp = x->valeur_effet[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_effet[j-1][0] = tmp;
        x->valeur_effet[j-1][3] = -1;
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_effet"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // changement de la valeur d'un data
        i = (int)atom_getfloatarg(3,argc,argv); // index du data
        j = x->data[i][0]; // position du data
        tmp = x->valeur_data[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_data[j-1][0] = tmp;
        x->valeur_data[j-1][3] = -1;
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_data"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("data_nb")))
    { // changement de la valeur d'un data
        j = (int)atom_getfloatarg(3,argc,argv); // index du data
        tmp = x->valeur_data[j-1][0];
        tmp += 5 * atom_getfloatarg(5,argc,argv);
        tmp = fmax(0,tmp);
        tmp = fmin(1,tmp);
        x->valeur_data[j-1][0] = tmp;
        x->valeur_data[j-1][3] = -1;
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("valeur_data"));
        SETFLOAT(&element[2],j); 
        SETFLOAT(&element[3],tmp); 
        outlet_anything(x->to_out,&s_list,4,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("valeur") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // changement de la valeur d'un groupe
        for (i=0; i< x->groupe[(int)atom_getfloatarg(3,argc,argv)][11]; i++)
        {
            int num_proj = x->groupe[(int)atom_getfloatarg(3,argc,argv)][12+i];
            tmp = x->valeur_circuit[num_proj][0];
            tmp += 5 * atom_getfloatarg(5,argc,argv);
            tmp = fmax(0,tmp);
            tmp = fmin(1,tmp);
            x->valeur_circuit[num_proj][0] = tmp;
            x->valeur_circuit[num_proj][3] = -1; // pas de line
            SETFLOAT(&element[0],0); // broadcast    
            SETSYMBOL(&element[1], gensym("valeur_circuit"));
            SETFLOAT(&element[2],num_proj);
            SETFLOAT(&element[3],tmp);
            outlet_anything(x->to_out,&s_list,4,element);            
        }
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // move projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][2] += atom_getfloatarg(4,argc,argv);
        x->projecteur[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->projecteur[i][2]=fmax(-1, x->projecteur[i][2]);
        x->projecteur[i][2]=fmin(1.6, x->projecteur[i][2]);
        x->projecteur[i][3]=fmax(-1, x->projecteur[i][3]);
        x->projecteur[i][3]=fmin(1, x->projecteur[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->projecteur[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->projecteur[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // move effet
        i = (int)atom_getfloatarg(3,argc,argv); // numero du effet
        x->effet[i][2] += atom_getfloatarg(4,argc,argv);
        x->effet[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->effet[i][2]=fmax(-1, x->effet[i][2]);
        x->effet[i][2]=fmin(1.6, x->effet[i][2]);
        x->effet[i][3]=fmax(-1, x->effet[i][3]);
        x->effet[i][3]=fmin(1, x->effet[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_effet"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->effet[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->effet[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // move groupe
        i = (int)atom_getfloatarg(3,argc,argv); // numero du groupe
        x->groupe[i][2] += atom_getfloatarg(4,argc,argv);
        x->groupe[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->groupe[i][2]=fmax(-1, x->groupe[i][2]);
        x->groupe[i][2]=fmin(1.6, x->groupe[i][2]);
        x->groupe[i][3]=fmax(-1, x->groupe[i][3]);
        x->groupe[i][3]=fmin(1, x->groupe[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_groupe"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->groupe[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->groupe[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // move data
        i = (int)atom_getfloatarg(3,argc,argv); // numero du data
        x->data[i][2] += atom_getfloatarg(4,argc,argv);
        x->data[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->data[i][2]=fmax(-1, x->data[i][2]);
        x->data[i][2]=fmin(1.6, x->data[i][2]);
        x->data[i][3]=fmax(-1, x->data[i][3]);
        x->data[i][3]=fmin(1, x->data[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_data"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->data[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->data[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // move forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][2] += atom_getfloatarg(4,argc,argv);
        x->forme[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->forme[i][2]=fmax(-1, x->forme[i][2]);
        x->forme[i][2]=fmin(1.6, x->forme[i][2]);
        x->forme[i][3]=fmax(-1, x->forme[i][3]);
        x->forme[i][3]=fmin(1, x->forme[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->forme[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->forme[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("move") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // move texte
        i = (int)atom_getfloatarg(3,argc,argv); // numero du texte
        x->texte[i][2] += atom_getfloatarg(4,argc,argv);
        x->texte[i][3] += atom_getfloatarg(5,argc,argv);  
        
        x->texte[i][2]=fmax(-1, x->texte[i][2]);
        x->texte[i][2]=fmin(1.6, x->texte[i][2]);
        x->texte[i][3]=fmax(-1, x->texte[i][3]);
        x->texte[i][3]=fmin(1, x->texte[i][3]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_texte"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],2); 
        SETFLOAT(&element[4],x->texte[i][2]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],3); 
        SETFLOAT(&element[4],x->texte[i][3]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // add projecteur
        j=0;
        while( (j<nb_max_circuit-1) & (x->projecteur[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; (i<11)&(i<argc-2); i++)
            x->projecteur[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("projecteur"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->projecteur[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // add effet
        j=0;
        while( (j<nb_max_circuit-1) & (x->effet[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; (i<11)&(i<argc-2); i++)
            x->effet[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("effet"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->effet[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if(atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // add data
        j=0;
        while( (j<nb_max_circuit-1) & (x->data[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; (i<11)&(i<argc-2); i++)
            x->data[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("data"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->data[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // add forme
        j=0;
        while( (j<nb_max_circuit-1) & (x->forme[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; (i<11)&(i<argc-2); i++)
            x->forme[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("forme"));
        SETFLOAT(&element[2],j);
        for (i=0; i<11; i++)
            SETFLOAT(&element[i+3],x->forme[j][i]);
        outlet_anything(x->to_out,&s_list,14,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // add groupe
        j=0;
        tmp = atom_getfloatarg(14,argc,argv); // nb lettre

        while( (j<nb_max_circuit-1) & (x->groupe[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; i< 12+tmp; i++)
            x->groupe[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("groupe"));
        SETFLOAT(&element[2],j);
        for (i=0; i<12+tmp; i++)
            SETFLOAT(&element[i+3],x->groupe[j][i]);
        outlet_anything(x->to_out,&s_list,15+tmp,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("add") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // add texte
        j=0;
        tmp = atom_getfloatarg(14,argc,argv); // nb lettre
        while( (j<nb_max_circuit-1) & (x->texte[j][0]!=0) ) j++; // on cherche un index vide
        for(i=0; i<12+tmp; i++)
            x->texte[j][i] = atom_getfloatarg(i+3,argc,argv);
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("texte"));
        SETFLOAT(&element[2],j);
        for (i=0; i<12+tmp; i++)
            SETFLOAT(&element[i+3],x->texte[j][i]);
        outlet_anything(x->to_out,&s_list,15+tmp,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rot") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // rot projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][8] += 100 * atom_getfloatarg(5,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],8); 
        SETFLOAT(&element[4],x->projecteur[i][8]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rot") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // rot forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][8] += 100 * atom_getfloatarg(5,argc,argv);
                
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],8); 
        SETFLOAT(&element[4],x->forme[i][8]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("rot") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // rot texte
        i = (int)atom_getfloatarg(3,argc,argv); // numero du texte
        x->texte[i][8] += 100 * atom_getfloatarg(5,argc,argv);

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_texte"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],8); 
        SETFLOAT(&element[4],x->texte[i][8]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("scale") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // scale forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][9] += 10*atom_getfloatarg(4,argc,argv);
        x->forme[i][10] += 10*atom_getfloatarg(5,argc,argv);  
        
        x->forme[i][9]=fmax(0.05, x->forme[i][9]);
        x->forme[i][9]=fmin(20, x->forme[i][9]);
        x->forme[i][10]=fmax(0.05, x->forme[i][10]);
        x->forme[i][10]=fmin(20, x->forme[i][10]);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],9); 
        SETFLOAT(&element[4],x->forme[i][9]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],10); 
        SETFLOAT(&element[4],x->forme[i][10]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("scale") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // scale texte
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->texte[i][9] += 10*atom_getfloatarg(5,argc,argv);
        x->texte[i][10] = x->texte[i][9];  
        
        x->texte[i][9]=fmax(0.5, x->texte[i][9]);
        x->texte[i][9]=fmin(20, x->texte[i][9]);

        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_texte"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],9); 
        SETFLOAT(&element[4],x->texte[i][9]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],10); 
        SETFLOAT(&element[4],x->texte[i][10]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("type") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // type projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][1] = atom_getfloatarg(4,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],1); 
        SETFLOAT(&element[4],x->projecteur[i][1]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("type") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // type effet
        i = (int)atom_getfloatarg(3,argc,argv); // numero du effet
        x->effet[i][1] = atom_getfloatarg(4,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_effet"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],1); 
        SETFLOAT(&element[4],x->effet[i][1]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("type") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // type groupe
        i = (int)atom_getfloatarg(3,argc,argv); // numero du groupe
        x->groupe[i][1] = atom_getfloatarg(4,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_groupe"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],1); 
        SETFLOAT(&element[4],x->groupe[i][1]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("type") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // type data
        i = (int)atom_getfloatarg(3,argc,argv); // numero du data
        x->data[i][1] = atom_getfloatarg(4,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_data"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],1); 
        SETFLOAT(&element[4],x->data[i][1]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("type") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // type forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][1] = atom_getfloatarg(4,argc,argv);
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],1); 
        SETFLOAT(&element[4],x->forme[i][1]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // del projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][0] = 0;
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // del effet
        i = (int)atom_getfloatarg(3,argc,argv); // numero du effet
        x->effet[i][0] = 0;
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_effet"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // del groupe
        i = (int)atom_getfloatarg(3,argc,argv); // numero du groupe
        x->groupe[i][0] = 0;  
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_groupe"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // del data
        i = (int)atom_getfloatarg(3,argc,argv); // numero du data
        x->data[i][2] = 0;  
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_data"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // del forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][2] = 0;  
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);

    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("del") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // del texte
        i = (int)atom_getfloatarg(3,argc,argv); // numero du texte
        x->texte[i][2] = 0;  
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_texte"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],0); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("number") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // number projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][0] += 50*atom_getfloatarg(5,argc,argv);
        
        x->projecteur[i][0]=fmax(1, x->projecteur[i][0]);
        x->projecteur[i][0]=fmin(nb_max_circuit, x->projecteur[i][0]);
        x->projecteur[i][0]=fmin(99, x->projecteur[i][0]); // TODO
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],x->projecteur[i][0]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("number") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // number effet
        i = (int)atom_getfloatarg(3,argc,argv); // numero du effet
        x->effet[i][0] += 50*atom_getfloatarg(5,argc,argv);  
        
        x->effet[i][0]=fmax(1, x->effet[i][0]);
        x->effet[i][0]=fmin(nb_max_circuit, x->effet[i][0]);
        x->effet[i][0]=fmin(99, x->effet[i][0]); // TODO
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_effet"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],x->effet[i][0]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("number") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // number data
        i = (int)atom_getfloatarg(3,argc,argv); // numero du data
        x->data[i][0] += 50*atom_getfloatarg(5,argc,argv);
        
        x->data[i][0]=fmax(1, x->data[i][0]);
        x->data[i][0]=fmin(nb_max_circuit, x->data[i][0]);
        x->data[i][0]=fmin(99, x->data[i][0]); // TODO
        
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_data"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],0); 
        SETFLOAT(&element[4],x->data[i][0]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("projecteur")))
    { // color projecteur
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->projecteur[i][4] = atom_getfloatarg(4,argc,argv);
        x->projecteur[i][5] = atom_getfloatarg(5,argc,argv);  
        x->projecteur[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_projecteur"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->projecteur[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->projecteur[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->projecteur[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("effet")))
    { // color effet
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->effet[i][4] = atom_getfloatarg(4,argc,argv);
        x->effet[i][5] = atom_getfloatarg(5,argc,argv);  
        x->effet[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_effet"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->effet[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->effet[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->effet[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("data")))
    { // color data
        i = (int)atom_getfloatarg(3,argc,argv); // numero du data
        x->data[i][4] = atom_getfloatarg(4,argc,argv);
        x->data[i][5] = atom_getfloatarg(5,argc,argv);  
        x->data[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_data"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->data[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->data[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->data[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // color groupe
        i = (int)atom_getfloatarg(3,argc,argv); // numero du groupe
        x->groupe[i][4] = atom_getfloatarg(4,argc,argv);
        x->groupe[i][5] = atom_getfloatarg(5,argc,argv);  
        x->groupe[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_groupe"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->groupe[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->groupe[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->groupe[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("forme")))
    { // color forme
        i = (int)atom_getfloatarg(3,argc,argv); // numero du forme
        x->forme[i][4] = atom_getfloatarg(4,argc,argv);
        x->forme[i][5] = atom_getfloatarg(5,argc,argv);  
        x->forme[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_forme"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->forme[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->forme[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->forme[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("color") & (atom_getsymbolarg(2, argc, argv) == gensym("texte")))
    { // color texte
        i = (int)atom_getfloatarg(3,argc,argv); // numero du projecteur
        x->texte[i][4] = atom_getfloatarg(4,argc,argv);
        x->texte[i][5] = atom_getfloatarg(5,argc,argv);  
        x->texte[i][6] = atom_getfloatarg(6,argc,argv);  

        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("change_texte"));
        SETFLOAT(&element[2],i); 
        SETFLOAT(&element[3],4); 
        SETFLOAT(&element[4],x->texte[i][4]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],5); 
        SETFLOAT(&element[4],x->texte[i][5]); 
        outlet_anything(x->to_out,&s_list,5,element);
        SETFLOAT(&element[3],6); 
        SETFLOAT(&element[4],x->texte[i][6]); 
        outlet_anything(x->to_out,&s_list,5,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("toggle_projecteur") & (atom_getsymbolarg(2, argc, argv) == gensym("groupe")))
    { // toggle_projecteur groupe
        int k;
        i = (int)atom_getfloatarg(3,argc,argv); // numero du groupe
        float proj_tgl = (int)atom_getfloatarg(4,argc,argv); // num du proj a ajouter ou suprimer
        tmp = x->groupe[i][11]; // nb de projecteurs ds le groupe
        int trouve = 0;
        
        for (j=0; j<tmp; j++)
        { // test si le proj est present ds le groupe
            if (x->groupe[i][12+j] == proj_tgl)
            { // on doit suprimer le contenue de l'index 12+j
                trouve = 1;
                x->groupe[i][11] = x->groupe[i][11]-1; // 1 proj de moins
                for (k=j; k<tmp-1; k++)
                    x->groupe[i][12+k] = x->groupe[i][k+13]; // on decale
                tmp --;
                j--;
            }
        }
        if (trouve == 0) // on n'a pas trouvé le proj, on l'ajoute
        {
            x->groupe[i][11] = x->groupe[i][11]+1; // 1 proj de plus
            x->groupe[i][(int)(11+x->groupe[i][11])] = proj_tgl;
        }
        // on renvoie tout le groupe...
        
        tmp = x->groupe[i][11]; 
        SETFLOAT(&element[0],0); // broadcast    
        SETSYMBOL(&element[1], gensym("groupe"));
        SETFLOAT(&element[2],i);
        for (j=0; j<12+tmp; j++)
            SETFLOAT(&element[j+3],x->groupe[i][j]);
        outlet_anything(x->to_out,&s_list,15+tmp,element);
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("inc_DMX"))
    {
        i = (int)atom_getfloatarg(2,argc,argv);
        if ((i>=0)&(i<=511))
        {
            x->valeur_DMX[i][1] = -1; // pour forcer l'envoie
            x->valeur_DMX[i][0] += 1000 * atom_getfloatarg(3,argc,argv);
            x->valeur_DMX[i][0] = fmin(x->valeur_DMX[i][0], 255);
            x->valeur_DMX[i][0] = floor(fmax(x->valeur_DMX[i][0], 0));
        }
    }
    else
    if (atom_getsymbolarg(1, argc, argv) == gensym("force_DMX"))
    {
        x->force_DMX[0] = (int)atom_getfloatarg(2,argc,argv);
        x->force_DMX[1] = (int)atom_getfloatarg(3,argc,argv);        
    }
    else
        post("message non géré");
}

void *jotac_new(void)
{
    int i;
    t_jotac *x = (t_jotac *)pd_new(jotac_class);

    x->to_out=outlet_new(&x->x_obj, 0);
    x->to_textefile=outlet_new(&x->x_obj, 0);

    for(i=0;i<nb_max_circuit;i++)
    {
        x->projecteur[i][0] = 0;
        x->effet[i][0] = 0;
        x->data[i][0] = 0;
        x->forme[i][0] = 0;
        x->groupe[i][0] = 0;
        x->texte[i][0] = 0;
        
        x->valeur_circuit[i][0] = 0;
        x->valeur_circuit[i][3] = -1; // pas de line
        x->valeur_effet[i][0] = 0;
        x->valeur_effet[i][3] = -1;        
        x->valeur_data[i][0] = 0;
        x->valeur_data[i][3] = -1;
        x->valeur_bus_lumiere[i] = 0;        
    }
    
    for(i=0;i<nb_max_DMX;i++)
        {
            x->valeur_DMX[i][1] = -1;    
            x->valeur_DMX[i][0] = 0;                
        }

    for(i=0;i<nb_max_memoires;i++)        
        SETSYMBOL(&x->nom_memoire[i], gensym("vide")); // nom des memoires
        
    for (i=0; i<nb_max_patch; i++)
    {
        x->patch[i][0]=-1;
        x->patch[i][1]=-1; // clear la cannal DMX associé a tout les projecteurs
        x->patch[i][2]=1; // amplitude
        x->patch[i][3]=0; // courbe
    }
    
    return (void *)x;
}

void jotac_setup(void) {
    jotac_class = class_new(gensym("jotac"), (t_newmethod)jotac_new,
        0, sizeof(t_jotac), CLASS_DEFAULT, 0);
    class_addbang(jotac_class, jotac_bang);
    class_addlist(jotac_class, jotac_list);
    class_addmethod(jotac_class, (t_method)jotac_time, gensym("time"), A_FLOAT, 0);
    class_addmethod(jotac_class, (t_method)jotac_save, gensym("save"), 0);
    class_addmethod(jotac_class, (t_method)jotac_reset, gensym("reset"), 0);
    
}
