uniform float f1, f2, f3, a1, a2, a3, t1, t2, t3;
const float pi = 3.1415927;
const float dx = 0.0001;
const float dy = 0.0001;

varying vec3 Normal;

vec4 f(float x,float y)
{

	float v = 0.;
	vec3 f= vec3(0.,0.,0.);
	float x_ = 1. - 2. * ((1. + x) / 149. * 150. / 2.) ;
	float y_ = 1. - 2. * ((1. + y) / 149. * 150. / 2.) ;
//	float x_ = x ;
//	float y_ = y ;

//	y_ = clamp (1.1 * y_,-1.,1. ) ;

	f.z = y_;
	f.x = cos(pi * x_) * sqrt(max(0.,1. - y_*y_));
	f.y = sin(pi * x_) * sqrt(max(0.,1. - y_*y_));

	v = 1. + a1 * sin (t1 + f1 * f.z);

	v+= a2 * sin (t2 + f2 * f.y);
	v+= a3 * sin (t3 + f3 * f.x);

	f *= v;

	return(vec4(f.xyz,1.));
}

vec4 dfx(float x, float y)
{
	return((f(x+dx,y)-f(x-dx,y))); 
}

vec4 dfy(float x, float y)
{
	return((f(x,y+dy)-f(x,y-dy))); 
}


void main(void)
	{
	vec4 v = vec4(gl_Vertex);
	vec4 fx = f(v.x,v.y);

	Normal = cross (dfx(v.x, max(-0.99,v.y)).xyz , dfy(v.x,max(-0.99,v.y)).xyz);

	Normal = normalize(Normal);

	gl_FrontColor = gl_Color;
	
	gl_Position = gl_ModelViewProjectionMatrix * fx ;
	} 
