const vec3 DiffuseColor= vec3( 0.1,0.3,0.1);
const vec3 PhongColor = vec3( 0.5,0.5,0.5);
const float Edge= 0.2;
uniform float Phong;
varying vec3 Normal;

void main (void)
{
	vec3 color = DiffuseColor;
	float f = dot(vec3(0,0,1),Normal);
	if (abs(f) < Edge)
		color = vec3(0);
	if (f > Phong)
		color = PhongColor;

	gl_FragColor = vec4(color, 1);
}
